/* Copyright (C) 2001, Linuxcare, Inc. */

/* This program is free software WITHOUT ANY WARRANTY; you may distribute
 * copies under the terms of the GNU General Public License, version 2,
 * or, at your option, any later version. */

/* Bug: check whether fd 0 and fd 1 exist before using them. */

/* Bug: too much mixing of read/write and stdio.  I try to use system calls
   whenever possible for speed, but there are a few fprintfs which should be
   converted.  I don't think there is any code path which mixes write and
   stdio on the same file. */

/* Todo: reverse destinations of stream output and checksum if filename
   given? */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "md5.h"

#define SIZE 16384

int main(int argc, char *argv[]){
	md5_state_t *md5_state;
	md5_byte_t result[16];
	md5_byte_t buf[SIZE];
	ssize_t n;
	char option;
	char *mode;
	int i, in_fd = 0, out_fd = 1, reverse;
	FILE *sum_destination = stderr;

/* Options */

	mode = "w";
	reverse = 0;

	while ((option = getopt(argc, argv, "ar")) != -1){
		switch(option){
			case 'a': { mode = "a"; break; }
			case 'r': { reverse = 1; break; }
		}
	}

	if (optind<argc){
		if ((sum_destination = fopen(argv[optind], mode)) == NULL){
			fprintf(stderr, "%s: can't open %s\n", argv[0], argv[1]);
			exit(1);
		}
	}

	md5_state = (md5_state_t *)malloc(sizeof(md5_state_t));
	md5_init(md5_state);
	if (reverse){
		while (n = read(in_fd, buf, SIZE)){
			md5_append(md5_state, buf, n);
			fwrite(buf, 1, n, sum_destination);
		}
	} else {
		while (n = read(in_fd, buf, SIZE)){
			md5_append(md5_state, buf, n);
			write(out_fd, buf, n);
		}
	}

	md5_finish(md5_state, result);
	free(md5_state);
	for (i = 0; i < 16; i++){
		fprintf(reverse?stdout:sum_destination, "%02x", result[i]);
	}
	fprintf(reverse?stdout:sum_destination, "\n");
	fclose(sum_destination);
	return 0;
}
